<?php include('session.php'); ?>

<?php if ($role_name != 'STAFF') { ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>APPROVAL TABLE</title>
    <?php include('dashboard.php'); ?> 
    <link rel="stylesheet" href="modal.css"> <!-- Link to your CSS file -->
    <link rel="stylesheet" href="styles.css"> <!-- Link to additional styles if needed -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> <!-- jQuery -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script> <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css"> <!-- DataTables CSS -->
</head>

<body>
<main>
    <div id="main_container">
        <div style="margin-top:80px" class="title_page">Approval Timesheet</div>

        <div class="container">
            <section>
                <br>
                <table id="example" class="table table-striped">
                    <thead>
                        <tr>
                            <th style="width:20%; background-color:black; color:white; font-weight:bold">Staff Name</th>
                            <th style="width:10%; background-color:black; color:white; font-weight:bold">Date</th>
                            <th style="width:10%; background-color:black; color:white; font-weight:bold">Project Code</th>
                            <th style="width:20%; background-color:black; color:white; font-weight:bold">Description</th>
                            <th style="width:20%; background-color:black; color:white; font-weight:bold">Client Name</th>
                            <th style="width:10%; background-color:black; color:white; font-weight:bold">Status</th>
                            <th style="width:10%; background-color:black; color:white; font-weight:bold">ACTION</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php

                        if($role_name == "SUPER ADMIN") {

                        $sql = "SELECT 
                            vtt_approval.vttapproval_pk,
                            staff_info.staff_name,
                            vtt_event.vtt_eventdate,
                            vtt_event.vttevent_pk, 
                            vtt_project.vtt_codeproject, 
                            vtt_project.vtt_nameproject, 
                            vtt_project.vtt_nameclient, 
                            vtt_event.vtt_normalhour, 
                            vtt_event.vtt_normalot, 
                            vtt_event.vtt_phot,
                            vtt_approval.vttstatus_pk, 
                            vtt_status.vttstatus_name
                        FROM 
                            staff_info
                        INNER JOIN vtt_event ON vtt_event.staff_pk = staff_info.staff_pk
                        INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_event.vttproject_pk
                        INNER JOIN vtt_approval ON vtt_approval.vttevent_pk = vtt_event.vttevent_pk
                        INNER JOIN vtt_status ON vtt_status.vttstatus_pk = vtt_approval.vttstatus_pk";
                        }
                        else
                        {
                            $sql = "SELECT
                                        vtt_approval.vttapproval_pk,
                                        staff_info.staff_name,
                                        vtt_event.vtt_eventdate,
                                        vtt_event.vttevent_pk,
                                        vtt_project.vtt_codeproject,
                                        vtt_project.vtt_nameproject,
                                        vtt_project.vtt_nameclient,
                                        vtt_event.vtt_normalhour,
                                        vtt_event.vtt_normalot,
                                        vtt_event.vtt_phot,
                                        vtt_approval.vttstatus_pk,
                                        vtt_status.vttstatus_name
                                    FROM
                                        staff_info
                                    INNER JOIN vtt_event ON vtt_event.staff_pk = staff_info.staff_pk
                                    INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_event.vttproject_pk
                                    INNER JOIN vtt_approval ON vtt_approval.vttevent_pk = vtt_event.vttevent_pk
                                    INNER JOIN vtt_status ON vtt_status.vttstatus_pk = vtt_approval.vttstatus_pk
                                    WHERE
                                        vtt_project.principle = $staff_pk";

                        }

                         $sql;

                        $result = $db->query($sql);

                        if ($result && $result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                        ?>
                                <tr style="text-align: center;">
                                    <td style="width:20%;"><?php echo htmlspecialchars($row["staff_name"]); ?></td>
                                    <td style="width:10%;"><?php echo htmlspecialchars($row["vtt_eventdate"]); ?></td>
                                    <td style="width:10%;"><?php echo htmlspecialchars($row["vtt_codeproject"]); ?></td>
                                    <td style="width:20%;"><?php echo htmlspecialchars($row["vtt_nameproject"]); ?></td>
                                    <td style="width:20%;"><?php echo htmlspecialchars($row["vtt_nameclient"]); ?></td>
                                    <td style="width:10%; color: <?php
                                        switch ($row["vttstatus_name"]) {
                                            case 'APPROVED':
                                                echo 'green';
                                                break;
                                            case 'REJECTED':
                                                echo 'red'; 
                                                break;
                                            case 'PENDING':
                                                echo 'blue'; 
                                                break;
                                        }
                                    ?>;">
                                        <?php echo htmlspecialchars($row["vttstatus_name"]); ?>
                                    </td>
                                    <?php if ($row['vttstatus_name'] == 'PENDING') { ?>
                                        <td style="width:10%;">
                                            <button class="status_reject" type="button" 
                                                onclick="window.location.href='approval_reject_process.php?vttapproval_pk=<?php echo $row['vttapproval_pk']; ?>'">
                                                REJECT
                                            </button>
                                        </td>
                                    <?php } else { ?>

                                        <?php if($role_name == 'SUPER ADMIN') {?>
                                        <td style="width:10%;">

                                        <button class="status_pending" type="button" 
                                                onclick="window.location.href='approval_amend_process.php?vttapproval_pk=<?php echo $row['vttapproval_pk']; ?>'">
                                                AMEND
                                        </button>

                                        </td>
                                        <?php } else {?>
                                            <td style="width:10%;">

                                            </td>
                                          <?php } ?>

                                          <?php }?>
                                </tr>
                        <?php 
                            } 
                        } else {
                            echo "<tr><td colspan='7'>No records found</td></tr>";
                        } 
                        ?>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</main>

<script>
    $(document).ready(function() {
        $('#example').DataTable({
            paging: true,
            searching: true,
            ordering: true,
            responsive: true
        });
    });
</script>

</body>
</html>

<?php } else {  echo "<script>window.location= 'calendar.php'</script>";  }?>
