<?php include('session.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VERITAS Event Calendar</title>
    <?php include('dashboard.php'); ?> 
</head>

<body>

<?php include('legends.php');

$legend_name = $_GET['legend_name'];

if($legend_name ==  'ALL')
{
   $page_name = "company_mergeevent.php";
}
elseif($legend_name ==  'APPROVED')
{
    $page_name = "company_approved.php";
}
elseif($legend_name ==  'PENDING')
{
    $page_name = "company_pending.php";
}
elseif($legend_name ==  'REJECTED')
{
    $page_name = "company_rejected.php";
}
elseif($legend_name ==  'EVENTS')
{
    $page_name = "company_events.php";
}
elseif($legend_name ==  'MEETING')
{
    $page_name = "company_meeting.php";
}
elseif($legend_name ==  'LEAVE')
{
    $page_name = "company_leave.php";
}
elseif($legend_name ==  'PUBLIC HOLIDAY')
{
    $page_name = "company_publicholiday.php";
}

    
?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar_event');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'timeGridWeek', // Default display mode
        selectable: true, // Allow date selection
        events: function(fetchInfo, successCallback, failureCallback) {
            // Fetch events dynamically from PHP script
            fetch('<?php echo $page_name; ?>')
                .then(response => response.json())
                .then(data => {
                    // Map the data to FullCalendar event format
                    var events = data.map(event => {
                        return {
                            title: event.title || event.description, // Use title or description based on data source
                            start: event.start || event.date, // Start date for events
                            end: event.end || event.date || '', // End date for events
                            status: event.status, // Status if available
                            };
                    });

                    // Process events to assign colors based on status
                    events.forEach(event => {
                        switch (event.status) {
                            case 'PENDING':
                                event.backgroundColor = '#D1CFC9'; // Light Blue
                                event.borderColor = '#D1CFC9'; // Light Blue
                                break;
                            case 'APPROVED':
                                event.backgroundColor = '#5E7C3C'; // Light Green //0ead00
                                event.borderColor = '#5E7C3C'; // Light Green
                                break;
                            case 'REJECTED':
                                event.backgroundColor = '#BF0200'; // Light Red
                                event.borderColor = '#BF0200'; // Light Red
                                break;
                            case 'MEETING':
                                event.backgroundColor = '#C24105'; // Light Red
                                event.borderColor = '#C24105'; // Light Red
                                break;
                            case 'EVENTS':
                                event.backgroundColor = '#4E49A5'; // Light Red
                                event.borderColor = '#4E49A5'; // Light Red
                                break;
                            case 'LEAVE':
                                event.backgroundColor = '#61afef'; // Light Red
                                event.borderColor = '#61afef'; // Light Red
                                break;
                                case 'PH':
                                event.backgroundColor = '#013220'; // Light Red
                                event.borderColor = '#013220'; // Light Red
                                break;
                            default:
                                event.backgroundColor = '#000000'; // Default color (Blue)
                                event.borderColor = '#000000'; // Default color (Blue)
                                break;
                        }
                    });

                    successCallback(events); // Send processed events back to FullCalendar
                })
                .catch(error => {
                    console.error('Error fetching events', error);
                    failureCallback(error);
                });
        },

        dateClick: function(info) {
            // Check if the click is on an all-day event area
            if (info.allDay) {
                var selectedDate = info.dateStr; // Selected date in YYYY-MM-DD format
                openPHPForm(selectedDate);
            }
        },

        headerToolbar: {
            start: 'dayGridMonth,timeGridWeek', // Display day, week, month buttons
            center: 'title', // Display title in the center
            end: 'today prev,next' // Display today, prev, next buttons
        },

        views: {
            timeGrid: {
                dayMaxEventRows: 10 // Adjust maximum number of events per day in timeGrid view
            },
            timeGridWeek: {
                slotMinTime: '08:00:00', // Set the minimum time for the time grid (8 AM)
                slotMaxTime: '25:00:00', // Set the maximum time for the time grid (6 PM)
                slotLabelInterval: '01:00', // Show labels at 1-hour intervals
                slotLabelAlign: 'start', // Align time labels to the start (left)
            }
        },

        // Handle changing views (day, week, month)
        viewDidMount: function(view) {
            // Update URL with current view type (day, week, month)
            var viewType = view.type;
            updateURL(viewType);
        }
    });

    calendar.render(); // Render the calendar

    function openPHPForm(date) {
        window.location.href = 'calendar_main.php?date=' + date;
    }

    function updateURL(viewType) {
        // Update URL based on the current view type (day, week, month)
        history.replaceState(null, null, viewType);
    }
});
</script>
</body>
</html>
