<?php
include('session.php');

// This will handle AJAX requests to fetch leave duration
if (isset($_GET['leave_type_id'])) {
    // Fetch the leave duration for the selected leave type
    $leave_type_id = $_GET['leave_type_id'];

    // Prepare SQL to fetch leave duration
    $query = "SELECT leave_duration FROM vtt_leave WHERE vttleave_pk = ?";
    $stmt = $db->prepare($query);
    $stmt->bind_param("i", $leave_type_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $response = array();
    if ($result->num_rows > 0) {
        // Fetch the leave duration
        $row = $result->fetch_assoc();
        $response['leave_duration'] = $row['leave_duration'];
    } else {
        // If no result, return a default value (or error)
        $response['leave_duration'] = 0; // Default duration if not found
    }

    // Return the response as JSON
    echo json_encode($response);
    exit(); // Stop further execution of the script after the AJAX response
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NEW LEAVE FORM</title>
    <?php include('dashboard.php'); ?>
    <script>
        // Function to handle the leave type change event
        function handleLeaveTypeChange() {
            var leaveTypeSelect = document.getElementById('vttleave_pk');
            var leaveDurationInput = document.getElementById('leave_duration');
            var leaveHourInput = document.getElementById('leave_hour');
            var leaveDurationRow = document.getElementById('leave_duration_row');
            var leaveHourRow = document.getElementById('leave_hour_row');

            var selectedLeaveType = leaveTypeSelect.value;
            
            // Check if a leave type is selected
            if (selectedLeaveType) {
                // Make an AJAX request to fetch leave duration based on the selected leave type
                var xhr = new XMLHttpRequest();
                xhr.open('GET', '?leave_type_id=' + selectedLeaveType, true); // Same page, with query params
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        var response = JSON.parse(xhr.responseText);
                        
                        // Assuming response contains the duration value
                        var leaveDuration = response.leave_duration;

                       
                            // Show leave duration input and hide leave hour input
                            leaveDurationInput.readOnly = false;
                            leaveDurationInput.value = leaveDuration; // Optionally set a default value
                            leaveDurationRow.style.display = 'table-row';
                            leaveHourRow.style.display = 'none';
                      
                    }
                };
                xhr.send();
            } else {
                // Reset the visibility if no leave type is selected
                leaveDurationRow.style.display = 'none';
                leaveHourRow.style.display = 'none';
            }
        }

        // Function to calculate leave end date based on start date and duration
        function calculateEndDate() {
            var startDate = document.getElementById('leave_startdate').value;
            var leaveDuration = parseInt(document.getElementById('leave_duration').value);

            if (startDate && leaveDuration) {
                var start = new Date(startDate);
                start.setDate(start.getDate() + leaveDuration -1); // Subtract 1 because the start date is included

                // Format the new end date to YYYY-MM-DD
                var endDate = start.toISOString().split('T')[0]; // Get YYYY-MM-DD format
                document.getElementById('leave_enddate').value = endDate;
            }
        }
    </script>
</head>
<body>
<main class="container_form">

<h4>LEAVE MAINTENANCE</h4>

<?php $date = $_GET['date']; ?>

<a style="margin-bottom:10px" onclick="window.location.href='calendar_main.php?date=<?php echo $date ?>'" class="btn" >Back</a>

<?php   
include('project_form.php');
?>

<form action="calendar_new_leave_process.php" method="post">
    <table>
        <tr>
            <td><label for="vttleave_pk">Leave Type</label></td>
            <td>
                <select id="vttleave_pk" name="vttleave_pk" onchange="handleLeaveTypeChange()">
                    <option value="">--Select Leave Type--</option>
                    <?php
                        // Fetch the leave options for the select dropdown
                        $leave_option = mysqli_query($db, "SELECT vttleave_pk, leave_code, leave_name, leave_duration FROM vtt_leave");
                        if ($leave_option->num_rows > 0) {
                            $options = mysqli_fetch_all($leave_option, MYSQLI_ASSOC);
                            foreach ($options as $option) {
                                echo "<option value='{$option['vttleave_pk']}'>{$option['leave_code']}</option>";
                            }
                        }
                    ?>
                </select>
            </td>
        </tr>

        <tr>
            <td><label for="leave_startdate">Start Date</label></td>
            <td><input type="date" id="leave_startdate" name="leave_startdate" required onchange="calculateEndDate()"></td>
            <input type="hidden" id="selected_date" name="selected_date" value="<?php echo $date;?>" required readonly>
        </tr>

        <tr>
            <td><label for="leave_enddate">End Date</label></td>
            <td><input type="date" id="leave_enddate" name="leave_enddate" required readonly></td>
        </tr>

        <tr id="leave_duration_row" style="display: none;">
            <td><label for="leave_duration">Duration (Days)</label></td>
            <td><input type="text" id="leave_duration" name="leaveevent_duration" class="readonly-input" required readonly></td>
        </tr>

        <tr>
            <td colspan="2">
                <input type="submit" value="Submit">
            </td>
        </tr>
    </table>
</form>

</main>
</body>
</html>
