<?php
include("db_vdgs.php");
include("session.php"); // Assuming session starts here

// Check connection
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the form data
    $vttleave_pk = $_POST['vttleave_pk'];
    $leave_startdate = $_POST['leave_startdate'];
    $leave_enddate = $_POST['leave_enddate'];
    $leaveevent_duration = $_POST['leaveevent_duration'];  // Ensure this is being used properly in your code
    $selected_date = $_POST['selected_date'];  // Date selected for the calendar page

    // Convert the input dates into DateTime objects
    $leave_startdate = new DateTime($leave_startdate);
    $leave_enddate = new DateTime($leave_enddate);

    // Sesuai untuk Principal Bukan untuk Admin
    $sql = "SELECT
                `leave_code`,
                `leave_name`,
                `leave_hour`,
                `leave_starthour`,
                `leave_endhour`,
                `leave_duration`
            FROM
                `vtt_leave`
            WHERE
                vttleave_pk = '$vttleave_pk'";

    $result = mysqli_query($db, $sql);

    $res = mysqli_fetch_array($result, MYSQLI_ASSOC);
    {
        //PAPARKAN NILAI ASAL    
        $leave_starthour = $res['leave_starthour'];
        $leave_endhour = $res['leave_endhour'];
    }

    // Combine the date and time into a single string (yyyy-mm-dd hh:mm:ss)
    $fullinitial_date = $leave_startdate->format('Y-m-d') . ' ' . $leave_starthour;
    $fullend_date = $leave_enddate->format('Y-m-d') . ' ' . $leave_endhour;

    // Convert the combined string into a Unix timestamp
    $fullinitial_date = strtotime($fullinitial_date);
    $fullend_date = strtotime($fullend_date);

    // Format the timestamp into dd/mm/yy hh:mm:ss format
    $fullinitial_date = date('y/m/d H:i:s', $fullinitial_date);
    $fullend_date = date('y/m/d H:i:s', $fullend_date);

    // Calculate the duration in days
    $duration = $leave_startdate->diff($leave_enddate);
    $duration = $duration->days;

    // Initialize the start date for the loop
    $increament_leave_startdate = $leave_startdate;

    // Prepare the SQL query with placeholders
    $sql_query = "INSERT INTO `vtt_leaveevent`(
                    `vttleave_pk`, `staff_pk`, `leave_startdate`, `leave_enddate`, `initial_date`, `last_date`, `fullinitial_date`, `fullend_date` 
                  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    // Attempt to prepare the statement
    $stmt = $db->prepare($sql_query);

    // Check if the statement preparation failed
    if ($stmt === false) {
        // Output the error and stop the script
        echo "Error in preparing the SQL statement: " . $db->error;
        exit;
    }

    $result = true; // Set result to true initially, will change to false if any insert fails

    $formatted_initial_date = $leave_startdate->format('Y-m-d');
    $formatted_last_date = $leave_enddate->format('Y-m-d');

// Initialize the start date for the loop (ensure it's a DateTime object)
$increament_leave_startdate = $leave_startdate;

// Loop through each day and insert into the database
for ($i = 0; $i <= $duration; $i++) { // Include the last day as well
    // Format the date for SQL (Y-m-d format)
    $formatted_start_date = $increament_leave_startdate->format('Y-m-d');

    // Combine the date and time into a single string (yyyy-mm-dd hh:mm:ss)
    $fullinitial_date = $formatted_start_date . ' ' . $leave_starthour;
    $fullend_date = $formatted_start_date . ' ' . $leave_endhour;

    // Convert the combined string into a Unix timestamp
    $fullinitial_date = strtotime($fullinitial_date);
    $fullend_date = strtotime($fullend_date);


    // Format the timestamp into dd/mm/yy hh:mm:ss format
    $fullinitial_date = date('y/m/d H:i:s', $fullinitial_date);
    $fullend_date = date('y/m/d H:i:s', $fullend_date);

    // Bind parameters to the prepared statement
    $stmt->bind_param("iissssss", $vttleave_pk, $staff_pk, $formatted_start_date, $formatted_start_date, $formatted_initial_date, $formatted_last_date, $fullinitial_date, $fullend_date);

    // Execute the query
    if (!$stmt->execute()) {
        // If any insert fails, mark result as false
        $result = false;
        break; // Stop further execution if any query fails
    }

    // Increment the start date by 1 day
    $increament_leave_startdate->modify('+1 day');
}


    // Check the result of the insert
    if ($result) {
        echo "<script>alert('New Leave Inserted'); window.location= 'calendar_main.php?date=$selected_date';</script>";
    } else {
        echo "<script>alert('Something Went Wrong!'); window.location= 'calendar_main.php?date=$selected_date';</script>";
    }

    // Close the statement
    $stmt->close();
}

// Close the database connection
$db->close();
?>
