<?php
// Include database connection file
include("session.php");
include("db_vdgs.php");

// Initialize an empty array to store events
$events = array();

// Third query: Fetch LEAVE data
$sql_leave = "SELECT DISTINCT
                    vtt_leave.leave_code,
                    vtt_leaveevent.fullinitial_date,
                    vtt_leaveevent.fullend_date
                FROM
                    vtt_leaveevent
                INNER JOIN vtt_leave ON vtt_leave.vttleave_pk = vtt_leaveevent.vttleave_pk
                WHERE
                    vtt_leaveevent.staff_pk = ?";

// Prepare the query and bind parameters for meetings
$stmt_leave = $db->prepare($sql_leave);
$stmt_leave->bind_param("i", $staff_pk);
$stmt_leave->execute();
$result_leave = $stmt_leave->get_result();

// Fetch leaves and add them to $events array
while ($row_leave = $result_leave->fetch_assoc()) {
    // Create an event array with required fields
    $leave_event = array(
        'title' => $row_leave['leave_code'],
        'start' => $row_leave['fullinitial_date'],
        'end' => $row_leave['fullend_date'],
        'status' => "LEAVE",  // Use status name for event status
        
    );

    // Add the event array to the events array
    $events[] = $leave_event;
}

// Close database connection
$db->close();

// Output JSON encoded array of all events
header('Content-Type: application/json');
echo json_encode($events);
?>
