<?php 
include('session.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EDIT COST RATE STAFF</title>
    <?php include('dashboard.php');?> 
    <?php include('modal.css');?>
</head>



<main class="container_form">
<h4>Cost Rate Calculator</h4>
<div class="form-group">
<a style="margin-bottom:0px" onclick="window.location.href='costrate_calculator.php'" class="btn">Back</a>
</div>

<body>
    <form action="#" method="post">
        <table>

            <tr>
                <td><label for="default_hours">Min Hours/Day</label></td>
                <td><input type="text" id="default_hours" name="default_hours" oninput="calculatedefaulthour()" oninput="calculateRemainingWorkingDay()"></td>
            </tr>

            <tr>
                <td><label for="working_day">WeekDays in Year</label></td>
                <td><input type="text" id="working_day" name="working_day" oninput="calculatedefaulthour()" oninput="calculateRemainingWorkingDay()"></td>
            </tr>

            <tr>
                <td><label for="costrate_default">Default Hour</label></td>
                <td><input type="text" id="costrate_default" name="costrate_default" oninput="calculateCostRate()"></td>
            </tr>


            <tr>
            <td colspan = '2'>
                
                <hr>
                
            </td>
           </tr>

           <tr>
                <td><label for="holiday_day">Holiday/Leave (Days)</label></td>
                <td><input type="text" id="holiday_day" name="holiday_day" oninput="calculateRemainingWorkingDay()"></td>
            </tr>


            <tr>
                <td><label for="working_day_remaining">Working Day (Remaining)</label></td>
                <td><input type="text" id="working_day_remaining" name="working_day_remaining" oninput="calculateRemainingWorkingDay()"></td>
            </tr>

            <tr>
                <td><label for="working_hour">Daily Input - consistently (Hours - VTT)</label></td>
                <td><input type="text" id="working_hour" name="working_hour" oninput="calculateRemainingWorkingDay()"></td>
            </tr>

            <tr>
                <td><label for="total_working_hour">Total Working Hour in Year</label></td>
                <td><input type="text" id="total_working_hour" name="total_working_hour" value=""  oninput="calculateRemainingWorkingDay()" oninput="calculateCostRate()"></td>
            </tr>







           <tr>
            <td colspan = '2'>
                
                <hr>
                
            </td>
           </tr>

           <tr>
                <td><label for="first_salary">First Salary (RM)</label></td>
                <td><input type="text" id="first_salary" name="first_salary" oninput="TotalSalary()"></td>
            </tr>

            <tr>
                <td><label for="first_duration">Duration First Salary (Months)</label></td>
                <td><input type="text" id="first_duration" name="first_duration" oninput="calculateSecondDuration()" oninput="TotalSalary()" ></td>
            </tr>

            <tr>
                <td><label for="second_salary">Second Salary (RM)</label></td>
                <td><input type="text" id="second_salary" name="second_salary" oninput="TotalSalary()" ></td>
            </tr>

            <tr>
                <td><label for="second_duration">Duration Second Salary (Months)</label></td>
                <td><input type="text" id="second_duration" name="second_duration" oninput="TotalSalary()"></td>
            </tr>

            <tr>
                <td><label for="total_salary">Total Salary (RM)</label></td>
                <td><input type="text" id="total_salary" name="total_salary" oninput="calculateCostRate()"></td>
            </tr>

            <tr>
            <td colspan = '2'>
                <hr>
                </td>
            <tr>

            <tr>
                <td><label for="total_costrate">Cost Rate (RM/Day)</label></td>
                <td><input type="text" id="total_costrate" name="total_costrate" ></td>
            </tr>


            </tr>
        </table>
    </form>
</body>
</main>

<script>
function calculatedefaulthour() {
    // Get the values from the inputs
    var default_hours = parseFloat(document.getElementById('default_hours').value);
    var working_day = parseFloat(document.getElementById('working_day').value);

    // Check if both values are numbers and calculate the total cost
    if (!isNaN(default_hours) && default_hours > 0 && !isNaN(working_day) && working_day > 0) {
        var costrate_default = default_hours * working_day;
        // Display the result in the "costrate_default" input, formatted to 2 decimal places
        document.getElementById('costrate_default').value = costrate_default.toFixed(2);
        // Trigger cost rate calculation after costrate_default is calculated
        calculateCostRate();
    } else {
        // If either input is invalid, clear the "costrate_default" field
        document.getElementById('costrate_default').value = '';
    }
}

function calculateSecondDuration() {
    // Get the values from the inputs
    var first_duration = parseFloat(document.getElementById('first_duration').value);

    // Check if both values are numbers and calculate the total cost
    if (!isNaN(first_duration) && first_duration) {
        var second_duration = 12 - first_duration;
        // Display the result in the "second_duration" input, formatted to 2 decimal places
        document.getElementById('second_duration').value = second_duration;
    } else {
        // If either input is invalid, clear the "second_duration" field
        document.getElementById('second_duration').value = '';
    }
}

function TotalSalary() {
    // Get the values from the inputs
    var first_salary = parseFloat(document.getElementById('first_salary').value);
    var second_salary = parseFloat(document.getElementById('second_salary').value);
    var first_duration = parseFloat(document.getElementById('first_duration').value);
    var second_duration = parseFloat(document.getElementById('second_duration').value);

    // Check if both values are numbers and calculate the total cost
    if (!isNaN(first_salary) && first_salary > 0 && !isNaN(second_salary) && second_salary > 0 && !isNaN(first_duration) && first_duration > 0 && !isNaN(second_duration)) {
        var total_salary = (first_salary * first_duration) + (second_salary * second_duration);
        // Display the result in the "total_salary" input, formatted to 2 decimal places
        document.getElementById('total_salary').value = total_salary.toFixed(2);
        // Trigger cost rate calculation after total_salary is updated
        calculateCostRate();
    } else {
        // If either input is invalid, clear the "total_salary" field
        document.getElementById('total_salary').value = '';
    }
}

function calculateCostRate() {
    // Get the values from the inputs
    var total_working_hour = parseFloat(document.getElementById('total_working_hour').value);
    var total_salary = parseFloat(document.getElementById('total_salary').value);

    // Check if both values are numbers and calculate the total cost
    if (!isNaN(total_salary) && total_salary > 0 && !isNaN(total_working_hour) && total_working_hour > 0) {
        var total_costrate = total_salary / total_working_hour;
        // Display the result in the "total_costrate" input, formatted to 2 decimal places
        document.getElementById('total_costrate').value = total_costrate.toFixed(2);
    } else {
        // If either input is invalid, clear the "total_costrate" field
        document.getElementById('total_costrate').value = '';
    }
}

function calculateRemainingWorkingDay() {
    // Get the values from the inputs
    var default_hours = parseFloat(document.getElementById('default_hours').value);
    var holiday_day = parseFloat(document.getElementById('holiday_day').value);
    var working_hour = parseFloat(document.getElementById('working_hour').value);
    var working_day = parseFloat(document.getElementById('working_day').value);
    var working_day_remaining = parseFloat(document.getElementById('working_day_remaining').value);
    var costrate_default = parseFloat(document.getElementById('costrate_default').value);
    var total_salary = parseFloat(document.getElementById('total_salary').value);
    var total_working_hour = parseFloat(document.getElementById('total_working_hour').value);

    // Check if both values are numbers and calculate the total cost
    if (!isNaN(holiday_day)) {
       

        if (!isNaN(working_day)) {

            var working_day_remaining = working_day - holiday_day;

            document.getElementById('working_day_remaining').value = working_day_remaining;

            var total_working_hour = working_day_remaining * working_hour;

            document.getElementById('total_working_hour').value = total_working_hour;
        
        }

    


    } else {
        // If either input is invalid, clear the "holiday_hour" field
        document.getElementById('holiday_hour').value = '';
    }
}

// Initialize the total cost calculation when the page loads
window.onload = function() {
    calculatedefaulthour();  // Calculate the default cost rate on load if any values are set
    TotalSalary();           // Calculate the total salary on load if any values are set
    calculateSecondDuration(); 
    calculateCostRate();
};

// Add event listeners to update the cost rate when the first duration changes
document.getElementById('first_duration').addEventListener('input', function() {
    TotalSalary();           // Recalculate total salary when first duration changes
    calculateCostRate();     // Recalculate cost rate when first duration changes
});

</script>

</html>
