<?php 
include('session.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EDIT COST RATE STAFF</title>
    <?php include('dashboard.php');?> 
    <?php include('modal.css');?>

    <style>
        table {
            width: 100%;
            border-collapse: collapse; /* Ensures that borders between cells collapse into a single border */
        }
        table, th, td {
            border: 1px solid black; /* Sets thick border for table and cells */
        }
        th, td {
            padding: 10px;
            text-align: left; /* Aligns text to the left */
        }
        th {
            background-color: #f2f2f2; /* Optional: Adds a light background color for the header */
        }
    </style>
</head>

<?php

// Get staffrate_pk from URL
$staffrate_pk = $_GET['staffrate_pk'];

// SQL query to fetch the staff rate details
$sql = "SELECT
            vtt_staffrate.staffrate_pk,
            staff_info.staff_name,
            staff_info.staff_pk,
            vtt_formularate.costrate_default,
            vtt_staffrate.costrate_totalamount,
            vtt_staffrate.total_hours,
            vtt_staffrate.total_costrate,
            staff_salary.salary_total
        FROM
            staff_info
        INNER JOIN vtt_staffrate ON vtt_staffrate.staff_pk = staff_info.staff_pk
        INNER JOIN vtt_formularate ON vtt_formularate.formularate_pk = vtt_staffrate.formularate_pk
        INNER JOIN staff_salary ON staff_salary.staff_pk = staff_info.staff_pk
        WHERE 
            vtt_staffrate.staffrate_pk = '$staffrate_pk'";  // Use staffrate_pk to fetch data

$result = mysqli_query($db, $sql);
$res = mysqli_fetch_array($result, MYSQLI_ASSOC);

if ($res) {
    $staffrate_pk = $res['staffrate_pk'];
    $staff_name = $res['staff_name'];
    $staff_pk = $res['staff_pk'];
    $costrate_default = $res['costrate_default'];
    $costrate_totalamount = $res['costrate_totalamount'];
    $total_hours = $res['total_hours'];
    $total_costrate = $res['total_costrate'];
    $salary_total = $res['salary_total'];
} else {
    // Handle case where no data is returned from the query (if necessary)
    echo "No data found for the given staff rate.";
    exit;
}
?>

<main class="container_form">
<h4>PROJECT CATEGORY EDIT</h4>
<div class="form-group">
<a style="margin-bottom:0px" onclick="window.location.href='costrate_staffTable.php'" class="btn">Back</a>
</div>

<body>
    <form action="#" method="post">
        <table>
            <input type="hidden" id="staffrate_pk" name="staffrate_pk" value="<?php echo $staffrate_pk?>">

            <tr>
                <td><label for="staff_name">Name</label></td>
                <td colspan='4'><input type="text" id="staff_name" name="staff_name" value="<?php echo $staff_name?>" readonly></td>
                
            </tr>

            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Salary Changes 2024</td>
            </tr>

            <tr>
                <td>Salary</td>
                <td>Duration Month</td>
                <td colspan = '2'>Total</td>
            </tr>

            <?php

            $sql = "SELECT
                    ssh.salaryHistory_startdate,
                    ssh.salaryHistory_enddate,
                    ssh.salaryHistory_total,
                    TIMESTAMPDIFF(MONTH, ssh.salaryHistory_startdate, ssh.salaryHistory_enddate) + 1 AS months_difference,
                    (TIMESTAMPDIFF(MONTH, ssh.salaryHistory_startdate, ssh.salaryHistory_enddate) + 1) * ssh.salaryHistory_total AS total_salary
                FROM
                    staff_salaryhistory ssh
                WHERE
                    YEAR(ssh.salaryHistory_startdate) = 2024
                AND 
                    ssh.staff_pk = '$staff_pk';
        ";

    $result = $db->query($sql);

    $accumulate_salary = 0;
															
	if ($result->num_rows > 0) {
    // output data of each row
	while($row = $result->fetch_assoc()) 
    {
        ?>

            <tr>
                <td>RM <?php echo $row["salaryHistory_total"];?></td>
                <td><?php echo $row["months_difference"];?> Months</td>
                <td  colspan = '2'>RM <?php echo $row["total_salary"];?></td>
            </tr>
            <?php

                $accumulate_salary = $accumulate_salary + $row["total_salary"];
                }}
                
                 
                ?>
           <tr>
                <td colspan = '2'>Accumulate Salary</td>
                <td colspan = '2'>RM <?php echo $accumulate_salary;?>.00</td>
            </tr>

            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Salary Changes 2024</td>
            </tr>

            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Formula Value</td>
            </tr>



                <?php
                            // SQL query to fetch the staff rate details
                $sql = "SELECT
                            `working_day`,
                            `default_hours`,
                            `costrate_default`,
                            `month`
                        FROM
                            `vtt_formularate`
                        WHERE
                            current_year = 2024";  // Use staffrate_pk to fetch data

                $result = mysqli_query($db, $sql);
                $res = mysqli_fetch_array($result, MYSQLI_ASSOC);

                if ($res) {
                    $working_day = $res['working_day'];
                    $default_hours = $res['default_hours'];
                  //  $costrate_default = $res['costrate_default'];
                    $month = $res['month'];

                    
                } else {
                    // Handle case where no data is returned from the query (if necessary)
                    echo "No data found for the given staff rate.";
                    exit;
                }

                                    // TOTAL Leave Duration Day
                                    $sql = "SELECT
                                                staff_info.staff_pk,
                                                vtt_leave.leave_name,
                                                vtt_leave.leave_duration
                                            FROM
                                                vtt_leaveevent
                                                INNER JOIN staff_info ON staff_info.staff_pk = vtt_leaveevent.staff_pk
                                                INNER JOIN vtt_leave ON vtt_leave.vttleave_pk = vtt_leaveevent.vttleave_pk
                                            WHERE
                                                staff_info.staff_pk = '$staff_pk'";  // Use staffrate_pk to fetch data
    
                                    $result = $db->query($sql);

                                    $total_leave = 0;
                                                                                            
                                    if ($result->num_rows > 0) {
                                    // output data of each row
                                    while($row = $result->fetch_assoc()) 
                                    {
                                        $total_leave = $total_leave + $row['leave_duration'];
                                    }

                                    }

                                    // TOTAL PUBLIC HOLIDAY
                                    $sql = "SELECT
                                                duration_ph
                                            FROM
                                            dashboard
                                            WHERE
                                                box_no = 7";  // Use staffrate_pk to fetch data

                        $result = $db->query($sql);

                        $duration_ph = 0;
                                                                                
                        if ($result->num_rows > 0) {
                        // output data of each row
                        while($row = $result->fetch_assoc()) 
                        {
                            $duration_ph = $duration_ph + $row['duration_ph'];
                        }

                        }

                ?>

            <tr>
                <td colspan='1'><label for="working_day">Weekdays</label></td>
                <td colspan='1'><input type="text" id="working_day" name="working_day" value="<?php echo $working_day?> Days" readonly></td>
                <td colspan='1'><input type="text" id="costrate_default" name="costrate_default" value="<?php echo $costrate_default?> Hours" readonly></td>

            </tr>

            <tr>
                <td colspan='1'><label for="total_leave">Leave</label></td>
                <td colspan='2'><input type="text" id="total_leave" name="total_leave" value="<?php echo $total_leave?> Days" readonly></td>
            </tr>

            <tr>
                <td colspan='1'><label for="duration_ph">Public Holiday</label></td>
                <td colspan='2'><input type="text" id="duration_ph" name="duration_ph" value="<?php echo $duration_ph?> Days" readonly></td>
            </tr>

            <?php

                 $remaining_workdays = $working_day - $duration_ph - $total_leave;
            ?>

            <tr>
                <td colspan='1'><label for="remaining_workdays">Remaining Workday</label></td>
                <td colspan='2'><input type="text" id="remaining_workdays" name="remaining_workdays" value="<?php echo $remaining_workdays?> Days" readonly></td>
            </tr>

            <?php 
                            $remaining_workdays = $working_day - $duration_ph - $total_leave;

                            $costrate_hour = $default_hours * $remaining_workdays;


                                //call out event_sumhour
                                $sql_check_sum = "SELECT
                                SUM(`costrate_value`) AS costrate_addamount
                            FROM
                                `vtt_event_sumdate`
                            WHERE
                                staff_pk ='$staff_pk'";
                
                                $result = mysqli_query($db, $sql_check_sum);
                
                                $res = mysqli_fetch_array($result, MYSQLI_ASSOC);
                                {
                                //PAPARKAN NILAI ASAL	
                                $costrate_addamount = isset($res['costrate_addamount']) ? $res['costrate_addamount'] : null;
                                }
                                //call out event_sumhour



                            $costrate_hour = $costrate_hour + $costrate_addamount;
            ?>

            <tr>
                <td colspan='1'><label for="costrate_addamount">Total Hour Keyed In</label></td>
                <td colspan='2'><input type="text" id="costrate_addamount" name="costrate_addamount" value="<?php echo $costrate_addamount = ($costrate_addamount == 0 || $costrate_addamount === null) ? 0 : $costrate_addamount;?> Hours" readonly></td>
            </tr>

            <tr>
                <td colspan='1'><label for="costrate_hour">Total Working Hours/Year</label></td>
                <td colspan='2'><input type="text" id="costrate_hour" name="costrate_hour" value="<?php echo $costrate_hour?> Hours" readonly></td>
            </tr>

            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Formula Value</td>
            </tr>

            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Cost Rate (RM / Day)</td>
            </tr>

            <?php 

                $cost_rate = $accumulate_salary /  $costrate_hour;
                $cost_rate = number_format($cost_rate, 2); // Format to 2 decimal places

            ?>
            <tr>
            <td colspan='1'><label for="cost_rate">Cost Rate</label></td>
            <td colspan='3'><input type="text" id="cost_rate" name="cost_rate" value="RM <?php echo $cost_rate?> / Day" readonly></td>
            </tr>
            <tr>
            <td colspan="4" style="text-align: center; font-weight: bolder;">Cost Rate (RM / Day)</td>
            </tr>


        </table>
    </form>
</body>
</main>


</html>
