<?php
// Include database connection file
include("session.php");
include("db_vdgs.php");
// Initialize an empty array to store events
$events = array();

// Prepare SQL query to fetch events
 $sql = "SELECT
            vtt_project.vtt_nameproject,
            vtt_event.vtt_eventdate,
            vtt_approval.vttstatus_pk,
            vtt_status.vttstatus_name
        FROM
            vtt_event
        INNER JOIN vtt_project ON vtt_project.vttproject_pk = vtt_event.vttproject_pk
        INNER JOIN vtt_approval ON vtt_approval.vttevent_pk = vtt_event.vttevent_pk
        INNER JOIN vtt_status ON vtt_status.vttstatus_pk = vtt_approval.vttstatus_pk
        WHERE
            vtt_event.staff_pk = $staff_pk"; // Adjust table name as per your database schema and session variable

$result = $db->query($sql);

// Fetch events and add them to $events array
while ($row = $result->fetch_assoc()) {
    // Create an event array with required fields
    $event = array(
        'title' => $row['vtt_nameproject'],
        'start' => $row['vtt_eventdate'], // Assuming your table has a 'date_event' column
        'status' => $row['vttstatus_name'] // Status of the event (e.g., 'PENDING', 'APPROVED', 'REJECTED')
    );

    // Add the event array to the events array
    $events[] = $event;
}

// Close database connection
$db->close();

// Output JSON encoded array of events
header('Content-Type: application/json');
echo json_encode($events);
?>
