<?php
// Include your database connection file
require_once 'db_vdgs.php';

if (isset($_GET['vttleave_pk'])) {
    $vttleave_pk = $_GET['vttleave_pk'];
    
    // Query to fetch leave details for the selected leave type
    $query = "SELECT leave_hour FROM vtt_leave WHERE vttleave_pk = ?";
    
    if ($stmt = $db->prepare($query)) {
        $stmt->bind_param('i', $vttleave_pk);  // Bind the vttleave_pk as an integer
        $stmt->execute();
        $stmt->bind_result($leave_hour);
        
        if ($stmt->fetch()) {
            // Return the result as a JSON response
            echo json_encode([
                'success' => true,
                'leave_hour' => $leave_hour
            ]);
        } else {
            echo json_encode(['success' => false]);
        }
        
        $stmt->close();
    }
}
?>
