<?php include('modal.css'); ?>

<div id="main_container">

    <!-- Modal -->
    <div class="modal" id="myModal">
        <div class="modal-content">

            <h3>Select Staff</h3>
            <form id="modalForm">
                <table id="example" class="table table-striped" style="width:100%;">
                    <thead>
                        <tr>
                            <th>Staff PK</th>
                            <th>Staff Name</th>
                            <th>Company</th>
                            <th>Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- DataTable from database -->
                    </tbody>
                </table>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript to handle modal functionality -->
<script>
    // Get the modal
    var modal = document.getElementById('myModal');
    // Get the button that opens the modal
    var btn = document.getElementById("openModalBtn");
    // Get the <span> element that closes the modal
    var span = document.getElementById("closeModalBtn");

    // When the user clicks the button, open the modal 
    btn.onclick = function() {
        modal.style.display = "block";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>

<script>
    $(document).ready(function() {
        var dataTable = $('#example').DataTable({
            "ajax": {
                "url": "addon_staff.php",
                "dataSrc": ""
            },
            "columns": [
                { "data": "staff_pk" },
                { "data": "staff_name" },
                { "data": "company_id" },
                { "data": "position" }
            ]
        });

        // Handle row click to populate form fields
        $('#example tbody').on('click', 'tr', function() {
            var data = dataTable.row(this).data();
            $('#idstaff_pk').val(data.staff_pk);
            $('#idstaff_name').val(data.staff_name);
            $('#idcompany_id').val(data.company_id);
            $('#idposition').val(data.position);
            modal.style.display = "none";  // Close modal after selection
        });

        // Handle form submission (if needed)
        $('#modalForm').submit(function(e) {
            e.preventDefault();
            var formData = $(this).serialize();
            // Add AJAX submission here if needed
        });
    });
</script>
